// CheetahBullet.js
//

function buildUI( tag ){
    
    tag.addParameterSelector("anchor type", [ "space", "target object" ], false, false);
    
    tag.addParameterLink("anchor target object", false);
    
    tag.addParameterString("vertex indices", "", true);
    tag.addParameterButton("set selected vertices", "set", "setSelectedVertices");
    
}

function setSelectedVertices( tag ) {
    var obj = tag.owner();
    
    if (obj.family() == NGONFAMILY) {
        var core = obj.core();
        var vertexCount = core.vertexCount();
        var indices = [];
        for (var i = 0;i < vertexCount;i++) {
            if (core.vertexSelection( i )) {
                indices.push(i);
            }
        }
        
        tag.setParameter("vertex indices", indices.toString());
    }
}